var Server = {
    api: '/',
    httpRequest: function (url, data, success, error, timeout) {
        var params = {
            url: url, //Адрес подгружаемой страницы
            type: "POST", //Тип запроса
            dataType: "html", //Тип данных
            data: data,
            success: success,
            error: error
        };
        if (timeout) params.timeout = timeout;
        $.ajax(params);
    },
    noConnectionError: function() {
//        alert('Ошибка подключения к серверу');
    },
    jsonRequest: function (url, data, success, error) {
        if (error === undefined) error = function () {
            Server.noConnectionError();
        };
        var successNew = function (data) {
            var json = Server.JSONParse(data);
            if (json === false) {
                error();
            } else {
                if (typeof(success) === 'function') {
                    success(json);
                }
            }
        };
        data = this.serialize(data);
        Server.request(url, data, successNew, error);
    },
    request: function (url, data, success, error) {
        url = Server.api + url;
        Server.httpRequest(url, data, success, error);
    },
    JSONParse: function (str) {
        var a;
        try {
            a = JSON.parse(str);
        } catch (e) {
            a = false;
        }
        return a;
    },
    serialize: function (obj, prefix) {
        var str = [];
        for (var p in obj) {
            if (obj.hasOwnProperty(p)) {
                var k = prefix ? prefix + "[" + p + "]" : p,
                    v = obj[p];
                str.push(typeof v === "object" ? this.serialize(v, k) : encodeURIComponent(k) + "=" + encodeURIComponent(v));
            }
        }
        return str.join("&");
    }

};