var calculateWindow = function (obj) {
    var width = obj.width();
    var height = obj.height();
    if (width > 1200) {
        $('.orderSpace').css('height', width / 4.44 + "px");
        $('.mobile .orderSpace').css('height', width / 8.88 + "px");
        $('.orderSpace').css('padding-top', width / 16 + "px");
        $('.orderSpace').css('background-size', "100% auto");
    } else {
        $('.orderSpace').css('height', "270px");
        $('.mobile .orderSpace').css('height', "250px");
        $('.orderSpace').css('padding-top', "75px");
        $('.orderSpace').css('background-size', "1200px auto");
        $('.mobile .orderSpace').css('background-size', "640px auto");
    }
    if (width > 1200) {
        $('.khimSpace').css('height', width / 4.44 + "px");
        $('.khimSpace').css('padding-top', width / 16 + "px");
        $('.khimSpace.pc').css('background-size', "100% auto");
    } else {
        $('.khimSpace').css('height', "270px");
        $('.khimSpace').css('padding-top', "75px");
        $('.khimSpace.pc').css('background-size', "1200px auto");
    }
};

function createStringByMaskAndDigits(mask, digits) {
    var currentDigitsIndex = 0;
    var index = false;
    var result = '';
    for (var i = 0; i < mask.length; ++i) {
        if (parseInt(mask[i]) || parseInt(mask[i]) === 0) {
            index = findFirstDigit(digits, currentDigitsIndex);
            if (index !== false) {
                result += digits[index];
                currentDigitsIndex = index + 1;
            } else {
                result += '_';
            }
        } else {
            result += mask[i];
        }
    }
    return result;
}

function findFirstDigit(array, startFrom) {
    for (var i = startFrom; i < array.length; ++i) {
        if (parseInt(array[i]) || parseInt(array[i]) === 0) {
            return i;
        }
    }
    return false;
}

function Tabs() {
    $('.tabs .header .item').click(function () {
        var tabs = $(this).closest('.tabs');
        var index = tabs.find('.header .item').index(this);
        console.log(index, this);
        tabs.find('.tab.active').fadeOut(0);
        tabs.find('.header .item.active').removeClass('active');
        tabs.find('.tab').eq(index).addClass('active').fadeIn(300);
        $(this).addClass('active');
    });
    var active = $('.tabs .header .item.active');
    active.each(function () {
        var tabs = $(this).closest('.tabs');
        var index = tabs.find('.header .item').index(this);
        console.log(index, this);
        tabs.find('.tab').eq(index).addClass('active').fadeIn(300);
    })
}

function Slider(changeInterval, fadeInTime) {
    function showNextSlide($slider) {
        var currentSlide = $slider.find('.slide.active');
        var $slides = $slider.find('.slide');
        var index = $slides.index(currentSlide);
        // index = index === -1 ? 0 : index;
        var nextIndex = index + 1;
        if ($slides.length < nextIndex + 1) nextIndex = 0;
        console.log($slider, changeInterval, index, nextIndex, $slides.length);
        $slides.eq(index).removeClass('active').fadeOut(0);
        $slides.eq(nextIndex).addClass('active').fadeIn(fadeInTime);
    }

    $('.slider_cb').each(function () {
        var slider = $(this);
        setInterval(function () {
            showNextSlide(slider);
        }, changeInterval)
    });
}

$().ready(function () {
    $(window).resize(function () {
        // calculateWindow($(this));
    });
    // calculateWindow($(window));

    $(window).scroll(function () {
        if ($(this).scrollTop() > 400) {
            $(".arrowUpSpace").css("display", "block");
        } else {
            $(".arrowUpSpace").css("display", "none");
        }
    });

    var options = {
        onComplete: function (cep) {
            alert('CEP Completed!:' + cep);
        },
        onKeyPress: function (cep, event, currentField, options) {
            console.log('A key was pressed!:', cep, ' event: ', event,
                'currentField: ', currentField, ' options: ', options);
        },
        onChange: function (cep) {
            console.log('cep changed! ', cep);
        },
        onInvalid: function (val, e, f, invalid) {
            var error = invalid[0];
            console.log("Digit: ", error.v, " is invalid for the position: ", error.p, ". We expect something like: ", error.e);
        }
    };

    $('input[name="phone"]').mask("+7 (999) 999-99-99", options);
    $(document).on('keydown', 'input[name="phone"]', function (e) {
        // Запрет на ввод 7 и 8 первой цифрой в номере
        if ((e.keyCode == 55 || e.keyCode == 56) && $(this).val() == '+7 (___) ___-__-__') {
            e.stopPropagation();
            e.preventDefault();
            return false;
        }
    });

    function handlePaste(e) {
        var clipboardData, pastedData;

        // Stop data actually being pasted into div
        e.stopPropagation();
        e.preventDefault();

        // Get pasted data via clipboard API
        clipboardData = e.clipboardData || window.clipboardData;
        pastedData = clipboardData.getData('Text');
        var a = pastedData.split('');
        if (pastedData[0] == '8' || pastedData[0] == '7') {
            a.splice(0, 1);
        }
        e.target.value = a.join('');
        // Do whatever with pasteddata
    }

    var inputs = $('input[name="phone"]');
    if (inputs.length > 0) {
        for (var i = 0; i < inputs.length; ++i) {
            inputs[i].addEventListener('paste', handlePaste);
        }
    }
    $('input[name="phonePrefix"]').mask("(999) 999-99-99");

    $('.vacancybutton').click(function () {
        if (!$('input[name="phonePrefix"]').val()) {
            $('input[name="phonePrefix"]').attr("required", "");
            return false;
        }
    });
    $('.topBanner .close').click(function () {
        $('.topBanner').css('margin-top', '-' + $('.topBanner').outerHeight() + 'px');
        setCookie('bannerClosed', '1', {expires: 3600 * 24 * 30 * 12 * 10})
    });
    $('.arrowUpSpace').click(function () {
        $("html, body").animate({scrollTop: 0}, "slow");
    })
    Tabs();
    // Slider(10000, 500);
    if (typeof Glide !== 'undefined') {
        new Glide('.glide', {
            type: 'carousel',
            startAt: 0,
            perView: 3
        }).mount();
    }
});

function addCertificate(button) {
    if ($(button).attr('disabled')) return;
    $(button).attr('disabled', 'disabled');
    let code = $(button).closest('.field').find('input').val();
    Server.jsonRequest('personal_addCertificate/', {code: code}, function (data) {
        if (data.success) {
            $(button).closest('.field').find('.error.message').addClass('hidden').html('');
            location.reload();
        } else {
            $(button).closest('.field').find('.error.message').removeClass('hidden').html(data.error);
        }
        $(button).removeAttr('disabled');
    });
}