$.fn.cbSpinner = function (options) {
    var settings = $.extend({
        disabled: false
    }, options);

    return this.each(function () {
        $(this).parent().find('div.cbSpinnerSpace').remove();
        $(this).css("display", "none");
        $(this).addClass("cbSpinnerInput");
        var defaultVal = parseInt($(this).attr("default"));
        var val = parseInt($(this).val());
        $(this).before('<div class="cbSpinnerSpace"><a href="#" class="minus"></a><span class="col">' + val + '</span><a href="#" class="plus"></a></div>');
        if (defaultVal != val) {
            $(this).parent().find(".cbSpinnerSpace").addClass("touched");
        }
        if (settings.disabled) {
            return this;
        }
        $(this).parent().find(".cbSpinnerSpace > a.minus").click(function () {
            var $mainUI = $(this).parent().parent().find(".cbSpinnerInput");
            var curVal = parseInt($mainUI.val());
            var min = parseInt($mainUI.attr('min'));
            curVal--;
            if (min > curVal) {
                return false;
            }
            $mainUI.val(curVal);
            $mainUI.parent().find(".cbSpinnerSpace > span.col").html(curVal);
            $mainUI.parent().find(".cbSpinnerSpace").addClass("touched");
            $mainUI.trigger("cbSpinnerChanged", curVal);
            return false;
        });
        $(this).parent().find(".cbSpinnerSpace > a.plus").click(function () {
            var $mainUI = $(this).parent().parent().find(".cbSpinnerInput");
            var curVal = parseInt($mainUI.val());
            var max = parseInt($mainUI.attr('max'));
            curVal++;
            if (max < curVal) {
                return false;
            }
            $mainUI.val(curVal);
            if (max == curVal) {
                var maxCaption = $mainUI.attr('maxCaption');
                if (maxCaption) {
                    $mainUI.parent().find(".cbSpinnerSpace > span.col").html(maxCaption);
                } else {
                    $mainUI.parent().find(".cbSpinnerSpace > span.col").html(curVal);
                }
            } else {
                $mainUI.parent().find(".cbSpinnerSpace > span.col").html(curVal);
            }
            $mainUI.parent().find(".cbSpinnerSpace").addClass("touched");
            $mainUI.trigger("cbSpinnerChanged", curVal);
            return false;
        });
        return this;
    });
};

$.fn.cbLabel = function () {
    return this.each(function () {
        $(this).find('a.info').remove();
        var hint = $(this).attr("rel");
        $(this).addClass("cbLabel");
        if (!hint) {
            return this;
        }
        var $span = $(this).find('span');
        var spanError = "";
        if ($span.hasClass('error')) {
            spanError = 'class="error"';
        }
        $(this).find('span').remove();
        if ($span.length) {
            $span.remove();
            $(this).append('<a class="info" href="#"><div><span></span>' + hint + '</div></a><span ' + spanError + '>' + $span.html() + '</span>');
        } else {
            $(this).append('<a class="info" href="#"><div><span></span>' + hint + '</div></a>');
        }
        $(this).find('a.info').hover(function () {
            // $('label.cbLabel a.info div').fadeOut();
            $(this).find('div').fadeIn(0);
            return false;
        }, function () {
            $(this).find('div').fadeOut(0);
            return false;
        });

        $(this).find('a.info').click(function (e) {
            e.stopPropagation();
            e.preventDefault();
            return false;
        });

        return this;
    });
};

$.fn.cbSelector = function (options) {
    var settings = $.extend({
        disabled: false
    }, options);

    return this.each(function () {
        $(this).parent().find(".cbSelectorSpace").remove();
        $(this).css("display", "none");
        $(this).addClass("cbSelectorInput");
        var defaultVal = $(this).attr("default");
        var caption = $(this).find('option:selected');
        var html = '<div class="cbSelectorSpace"><p>' + caption.html() + '</p><span></span><ul>';

        $(this).find('option').each(function () {
            html += '<li rel="' + $(this).val() + '">' + $(this).html() + '</li>';
        });

        html += "</ul></div>";

        $(this).before(html);

        if (defaultVal !== $(this).val()) {
            $(this).parent().find(".cbSelectorSpace").addClass("touched");
        }

        if ($(this).hasClass("big")) {
            $(this).parent().find(".cbSelectorSpace").addClass("big");
        }
        if (settings.disabled) {
            return this;
        }
        $(this).parent().find('div.cbSelectorSpace').click(function () {
            if ($(this).find('ul').css("display") === "block") {
                $(this).find('ul').slideUp(200);
            } else {
                $(this).find('ul').slideDown(200);
            }
            $(this).addClass("touched");
            var _this = this;
            $(window).click(function () {
                $(_this).find('ul').slideUp(200);
                $(window).unbind();
            });

            return false;
        });

        $(this).parent().find('div.cbSelectorSpace > ul > li').click(function () {
            var value = $(this).attr("rel");
            var text = $(this).html();
            var $selector = $(this).parent().parent().parent().find('select');
            $selector.find('option').removeAttr('selected');
            $selector.find('option[value="' + value + '"]').prop("selected", "selected");
            var $_this = $(this);
            $(this).parent().slideUp(100, function () {
                $_this.parent().parent().find("p").html(text);
                $selector.trigger("cbSelectorChanged", value);
            });
        });
    });
};

$.fn.cbSelectorMobile = function (options) {
    var settings = $.extend({
        disabled: false
    }, options);

    return this.each(function () {
        $(this).parent().find(".cbSelectorSpace").remove();
        $(this).css("display", "none");
        $(this).addClass("cbSelectorInput");
        var _this = this;
        var defaultVal = $(this).attr("default");
        var caption = $(this).find('option:selected');
        $(this).before('<div class="cbSelectorSpace"><a href="#" class="minus"></a><span class="col">' + caption.html() + '</span><a href="#" class="plus"></a></div>');
        var index = 0;
        var i = 0;
        $(this).find('option').each(function () {
            if (caption.val() === $(this).val()) {
                index = i;
            }
            i++;
        });

        $(this).parent().find(".cbSelectorSpace").data("index", index);

        if (defaultVal !== $(this).val()) {
            $(this).parent().find(".cbSelectorSpace").addClass("touched");
        }

        if (settings.disabled) {
            return this;
        }

        $(this).parent().find(".cbSelectorSpace > a.minus").click(function () {
            var curIndex = parseInt($(this).parent().data("index"));
            curIndex--;
            if (curIndex < 0) {
                return false;
            }
            $(_this).find('option').removeAttr('selected');
            $(_this).find('option').eq(curIndex).prop("selected", "selected");
            $(this).parent().data("index", curIndex);
            var caption = $(_this).find('option:selected');
            $(this).parent().find('span.col').html(caption.html());
            $(_this).trigger("cbSelectorChanged", caption.val());
            return false;
        });

        $(this).parent().find(".cbSelectorSpace > a.plus").click(function () {
            var curIndex = parseInt($(this).parent().data("index"));
            curIndex++;
            if (curIndex >= $(_this).find('option').length) {
                return false;
            }
            $(_this).find('option').removeAttr('selected');
            $(_this).find('option').eq(curIndex).prop("selected", "selected");
            $(this).parent().data("index", curIndex);
            var caption = $(_this).find('option:selected');
            $(this).parent().find('span.col').html(caption.html());
            $(_this).trigger("cbSelectorChanged", caption.val());
            return false;
        });

    });
};

$.fn.cbRadio = function (options) {
    var settings = $.extend({
        disabled: false
    }, options);

    return this.each(function () {
        $(this).parent().find('.cbRadio').remove();
        var id = $(this).attr("id");
        $(this).css("display", "none");
        $(this).addClass("cbRadioInput");
        $(this).before('<div class="cbRadio"></div>');
        var name = $(this).attr('name');
        var val = $(this).val();
        var curVal = $('input[name="' + name + '"]:checked').val();
        if (val === curVal) {
            $(this).parent().find('.cbRadio').addClass("touched");
        }
        var $curUI = $(this);
        if (settings.disabled) {
            return this;
        }

        if (id) {
            $('label[for="' + id + '"]').unbind();
            $('label[for="' + id + '"]').click(function () {
                if ($(this).hasClass("touched")) {
                    return false;
                }
                $('input[name="' + name + '"]').removeAttr("checked");
                $('input[name="' + name + '"]').parent().find(".cbRadio").removeClass("touched");
                $curUI.prop("checked", "checked");
                var value = $curUI.val();
                $curUI.parent().find('.cbRadio').addClass("touched");
                $curUI.trigger("cbRadioChanged", value);
                return false;
            });
        }

        $(this).parent().find('.cbRadio').click(function () {
            if ($(this).hasClass("touched")) {
                return false;
            }
            $('input[name="' + name + '"]').removeAttr("checked");
            $('input[name="' + name + '"]').parent().find(".cbRadio").removeClass("touched");
            $curUI.prop("checked", "checked");
            var value = $curUI.val();
            $curUI.parent().find('.cbRadio').addClass("touched");
            $curUI.trigger("cbRadioChanged", value);
            return false;
        });
    });
};

$.fn.cbCheckbox = function (options) {
    var settings = $.extend({
        disabled: false
    }, options);
    return this.each(function () {
        $(this).parent().find('.cbCheckbox').remove();
        $(this).css("display", "none");
        $(this).addClass("cbCheckboxInput");
        $(this).before('<div class="cbCheckbox"></div>');
        var name = $(this).attr('name');
        var $checked = $('input[name="' + name + '"]:checked');
        if (this.checked) {
            $(this).parent().find('.cbCheckbox').addClass("touched");
        }
        var $curUI = $(this);
        if (settings.disabled) {
            return this;
        }
        $(this).parent().find('.cbCheckbox').click(function () {
            var value = $curUI.val();
            if ($(this).hasClass('touched')) {
                $curUI.removeAttr('checked');
                $(this).removeClass('touched');
                $curUI.trigger("cbCheckboxUnchecked", value);
            } else {
                $curUI.prop("checked", "checked");
                $(this).addClass('touched');
                $curUI.trigger("cbCheckboxChecked", value);
            }
            return false;
        });
    });
};

function cbCalendar($table, startDate, minDate) {
    var today = new Date();
    var Dlast = new Date(startDate.getFullYear(), startDate.getMonth() + 1, 0).getDate(),
        D = new Date(startDate.getFullYear(), startDate.getMonth(), Dlast),
        DNlast = new Date(D.getFullYear(), D.getMonth(), Dlast).getDay(),
        DNfirst = new Date(D.getFullYear(), D.getMonth(), 1).getDay(),
        calendar = '<tr>',
        month = ["Январь", "Февраль", "Март", "Апрель", "Май", "Июнь", "Июль", "Август", "Сентябрь", "Октябрь", "Ноябрь", "Декабрь"];
    if (DNfirst != 0) {
        for (var i = 1; i < DNfirst; i++)
            calendar += '<td>';
    } else {
        for (var i = 0; i < 6; i++)
            calendar += '<td></td>';
    }

    for (var i = 1; i <= Dlast; i++) {
        var curDateMax = new Date(D.getFullYear(), D.getMonth(), i, 23, 59, 59);
        var curDate = new Date(D.getFullYear(), D.getMonth(), i, today.getHours(), today.getMinutes(), today.getSeconds());
        if (curDateMax.getTime() > minDate.getTime()) {
            calendar += '<td><a class="date" href="' + curDate.getTime() + '">' + i + "</a></td>";
        } else {
            calendar += '<td>' + i + "</td>";
        }

        if (new Date(D.getFullYear(), D.getMonth(), i).getDay() == 0) {
            calendar += '<tr>';
        }
    }

    for (var i = DNlast; i < 7; i++)
        calendar += '<td>&nbsp;</td>';
    calendar += "</tr>";
    $table.find('tbody').html(calendar);
    $table.find('thead td').eq(1).html('<span class="monthTitle">' + month[D.getMonth()] + ' ' + D.getFullYear() + '</span>');
    $table.data("curDate", D);
    $table.find('a.date').click(function () {
        var value = new Date(parseInt($(this).attr("href")));
        var date = str_pad(value.getDate(), 2, '0', 'STR_PAD_LEFT');
        var month = str_pad((value.getMonth() + 1), 2, '0', 'STR_PAD_LEFT');
        var year = str_pad(value.getFullYear(), 2, '0', 'STR_PAD_LEFT');
        $table.parent().parent().parent().find("input.cbDatepicker").val(date + "." + month + "." + year);
        $table.fadeOut(100);
        $table.parent().parent().parent().find("input.cbDatepicker").trigger("cbDatepickerChanged", value);
        return false;
    });
}

$.fn.cbDatepicker = function (options) {
    var settings = $.extend({
        minDate: new Date()
    }, options);

    return this.each(function () {
        var val = parseInt($(this).val());
        var curDate = settings.minDate;
        if (val > 100000) {
            curDate = new Date(val);
        }
        $(this).parent().find('.cbDatepickerPickSpace').remove();
        $(this).after('<div class="cbDatepickerPickSpace"><span class="cbDatepickerPick"></span><table><thead><tr><td><a class="prev" href="#">&laquo;</a></td><td colspan="5"></td><td><a class="next" href="#">&raquo;</a></td></tr><tr><td class="weekTitle">Пн</td><td class="weekTitle">Вт</td><td class="weekTitle">Ср</td><td class="weekTitle">Чт</td><td class="weekTitle">Пт</td><td class="weekTitle">Сб</td><td class="weekTitle">Вс</td></tr><tbody></table></div>');
        var $table = $(this).parent().find('table');
        cbCalendar($table, new Date(), settings.minDate);
        var date = str_pad(curDate.getDate(), 2, '0', 'STR_PAD_LEFT');
        var month = str_pad((curDate.getMonth() + 1), 2, '0', 'STR_PAD_LEFT');
        var year = str_pad(curDate.getFullYear(), 2, '0', 'STR_PAD_LEFT');

        $(this).val(date + "." + month + "." + year);

        $(this).parent().find('span.cbDatepickerPick').click(function () {
            $('.cbDatepicker').parent().find('.cbDatepickerPick table').fadeOut(100);
            $table.fadeIn(100);
            $(window).click(function () {
                $table.fadeOut(100);
                $(window).unbind();
            });
            return false;
        });

        // переключатель минус месяц
        $table.find('a.prev').click(function () {
            cbCalendar($table, new Date($table.data("curDate").getFullYear(), $table.data("curDate").getMonth() - 1, 1), settings.minDate);
            return false;
        });

        // переключатель плюс месяц
        $table.find('a.next').click(function () {
            cbCalendar($table, new Date($table.data("curDate").getFullYear(), $table.data("curDate").getMonth() + 1, 1), settings.minDate);
            return false;
        });
    });
};

$.fn.cbTimepicker = function (options) {
    var settings = $.extend({
        minDate: new Date(),
        maxHours: 20,
        minHours: 8,
        minMinutes: 30
    }, options);

    return this.each(function () {
        var val = parseInt($(this).val());
        var valDate = settings.minDate;
        if (val) {
            valDate = new Date(val);
            var valDateBegin = new Date(valDate.getFullYear(), valDate.getMonth(), valDate.getDate(), settings.minHours, settings.minMinutes, 0);
            if (valDateBegin.getTime() > settings.minDate.getTime()) {
                settings.minDate = valDateBegin;
            }
        }
        $(this).css("display", "none");
        $(this).parent().find('.cbTimepickerSelector').remove();
        $(this).val(valDate.getTime());
        var html = '<select class="cbTimepickerSelector">';
        var firstHour = settings.minDate.getHours();
        firstHour = settings.minHours;
        for (var i = firstHour; i < settings.maxHours; i++) {
            var hours = str_pad(i, 2, '0', 'STR_PAD_LEFT');
            var curDatetime = new Date(settings.minDate.getFullYear(), settings.minDate.getMonth(), settings.minDate.getDate(), i, 0, 0);
            var selected = '';
            if (valDate.getTime() == curDatetime.getTime()) {
                selected = 'selected=""';
            }
            // if (i != 8) {
            html += '<option ' + selected + ' value="' + curDatetime.getTime() + '">' + hours + ":" + "00" + '</option>';
            // }
            curDatetime = new Date(settings.minDate.getFullYear(), settings.minDate.getMonth(), settings.minDate.getDate(), i, 30, 0);
            selected = '';
            if (valDate.getTime() == curDatetime.getTime()) {
                selected = 'selected=""';
            }
            html += '<option ' + selected + ' value="' + curDatetime.getTime() + '">' + hours + ":" + "30" + '</option>';
        }
        var curDatetime = new Date(settings.minDate.getFullYear(), settings.minDate.getMonth(), settings.minDate.getDate(), settings.maxHours, 0, 0);
        var hours = str_pad(settings.maxHours, 2, '0', 'STR_PAD_LEFT');
        html += '<option value="' + curDatetime.getTime() + '">' + hours + ":" + "00" + '</option>';
        html += "</select>";
        $(this).after(html);
        var $curUI = $(this);
        $(this).parent().find('.cbTimepickerSelector').change(function () {
            var value = $(this).val();
            $curUI.val(value);
            $curUI.trigger("cbTimepickerChanged", value);
        });
        $curUI.trigger("cbTimepickerChanged", $curUI.val());
    });
};

$.fn.cbPromo = function (options) {
    var settings = $.extend({
        action: "",
        typingTimeout: 1000
    }, options);
    var typingTimmer = undefined;
    return this.each(function () {
        $(this).addClass("cbPromo");
        if (settings.action) {
            $(this).bind("cbPromoEvent", settings.action);
        }
        var $curUI = $(this);
        $(this).keypress(function () {
            if (typingTimmer) {
                clearTimeout(typingTimmer);
            }
            typingTimmer = setTimeout(function () {
                $curUI.trigger("cbPromoEvent", $curUI.val());
            }, settings.typingTimeout);
        });
        $(this).bind("input paste", function () {
            if (typingTimmer) {
                clearTimeout(typingTimmer);
            }
            typingTimmer = setTimeout(function () {
                $curUI.trigger("cbPromoEvent", $curUI.val());
            }, settings.typingTimeout);
        });
    });
};

$.fn.cbDialog = function (options) {
    var settings = $.extend({
        onCbDialogSubmitted: ""
    }, options);

    return this.each(function () {
        var $container = $(this);
        var showModal = function () {
            $container.animate({opacity: 'toggle'}, {
                duration: 200, start: function () {
                    $(this).css('display', 'table');
                }
            });
        };
        $container.find('a.close').click(function () {
            $container.fadeOut();
            $('body').removeClass('overflow');
            $container.trigger("cbDialogCanceled");
            return false;
        });

        if (settings.onCbDialogSubmitted) {
            $container.bind("onCbDialogSubmitted", settings.onCbDialogSubmitted);
        }

        $container.find('.submit').click(function () {
            var data = {};
            var error = false;
            $container.find('input, select').each(function () {
                data[$(this).attr("name")] = $(this).val();
                if ($(this).val() === "" && $(this).hasClass("required")) {
                    error = true;
                    $(this).addClass("error");
                } else {
                    $(this).removeClass("error");
                }
            });
            if (error) {
                return false;
            }
            if (settings.onCbDialogSubmitted) {
                $container.trigger("onCbDialogSubmitted", data);
            }
            $container.fadeOut();
            $('body').removeClass('overflow');
            return false;
        });
    });
};

$.fn.cbButton = function () {
    return this.each(function () {
        $(this).addClass("cbButton");
        $(this).find('span').css('display', 'none');
        $(this).click(function () {
            if ($(this).find('span').css('display') === "inline-block") {
                return false;
            }
            $(this).find('span').css('display', 'inline-block');
            $(this).trigger('cbButtonClick');
            return false;
        });
    });
};

function toggleAdvice(advice) {
    if ($(advice).hasClass('active')) {
        $(advice).removeClass('active');
    } else {
        $('.advice').removeClass('active');
        $(advice).addClass('active');
    }
}
function openCurrentAdvice() {
    $('.advice .title[href="' + location.hash + '"]').parent().addClass('active');
}